# WORDPAD Sample: The Windows Application

WORDPAD is the word processing application included with Windows. It is an example of a full-fledged word processing application written using MFC.

WORDPAD comes with a help file describing its user interface.

### Security Note
This sample code is provided to illustrate a concept and should not be used in applications or Web sites, as it may not illustrate the safest coding practices.

## Building and Running the Sample

### To build and run the WORDPAD sample

1. Open the solution wordpad.sln.

2. On the **Build** menu, click **Build**.

3. Run WordPad as a stand-alone application so it can register itself with the system.

## WORDPAD Features

The SUPERPAD sample illustrates a basic word processor based on the **CEditView** class. In contrast, WORDPAD is based on the **CRichEditView**, **CRichEditDoc**, and **CRichEditCntrItem** classes, and — besides supporting the features that SUPERPAD supports — also demonstrates the following features.

* The ability to read, write, and convert between multiple file formats, including the Word file format, .rtf (Rich Text Format) format, and ASCII text format.

* Text formatting, including the use of fonts, character formatting (bold, italics, underlining), color, and point sizes. These attributes are available in a formatting toolbar.

* Per-paragraph formatting, including alignment (left, center, or right), tabs, margins, and first-line indentation. These attributes are also available in a ruler toolbar.

* Undo support.

* ActiveX component support, both container and server.

## Keywords

This sample demonstrates the following keywords:

AfxBeginThread; AfxFormatString1; AfxFormatString2; AfxGetApp; AfxGetAppName; AfxGetInstanceHandle; AfxGetMainWnd; AfxMessageBox; AfxOleGetMessageFilter; AfxOleInit; AfxOleSetUserCtrl; AfxRegisterClass; AfxRegisterWndClass; AfxThrowFileException; AfxThrowNotSupportedException; AfxThrowResourceException; BitBlt; CArchive::Close; CArchive::Read; CArchive::Write; CBrush::CreateSolidBrush; CButton::DrawItem; CComboBox::AddString; CComboBox::CompareItem; CComboBox::Create; CComboBox::DrawItem; CComboBox::FindString; CComboBox::FindStringExact; CComboBox::GetCount; CComboBox::GetCurSel; CComboBox::GetDroppedState; CComboBox::GetItemData; CComboBox::GetItemHeight; CComboBox::GetLBText; CComboBox::InsertString; CComboBox::LimitText; CComboBox::MeasureItem; CComboBox::ResetContent; CComboBox::SetCurSel; CComboBox::SetItemData; CComboBox::SetItemHeight; CComboBox::ShowDropDown; CControlBar::EnableDocking; CDC::Attach; CDC::BitBlt; CDC::CreateCompatibleDC; CDC::CreateIC; CDC::Detach; CDC::DrawFocusRect; CDC::DrawText; CDC::ExtTextOut; CDC::FillRect; CDC::GetBkColor; CDC::GetDeviceCaps; CDC::GetTextColor; CDC::GetTextExtent; CDC::GetTextMetrics; CDC::LineTo; CDC::MoveTo; CDC::Rectangle; CDC::RestoreDC; CDC::SaveDC; CDC::SelectObject; CDC::SetBkMode; CDC::SetTextColor; CDC::SetViewportOrg; CDC::TextOut; CDialog::Create; CDialog::DoModal; CDialog::EndDialog; CDialog::GetDefID; CDialog::InitModalIndirect; CDialog::OnInitDialog; CDialog::OnOK; CDialog::SetDefID; CDocTemplate::GetDocString; CDocument::GetFirstViewPosition; CDocument::GetNextView; CFile::Abort; CFile::Close; CFile::Flush; CFile::GetLength; CFile::GetPosition; CFile::GetStatus; CFile::LockRange; CFile::Open; CFile::Read; CFile::Seek; CFile::SeekToBegin; CFile::SetLength; CFile::UnlockRange; CFile::Write; CFileDialog::DoModal; CFont::CreateFontIndirect; CFrameWnd::ActivateFrame; CFrameWnd::Create; CFrameWnd::DockControlBar; CFrameWnd::EnableDocking; CFrameWnd::GetActiveDocument; CFrameWnd::GetActiveView; CFrameWnd::RecalcLayout; CFrameWnd::SetMessageText; CGdiObject::Attach; CGdiObject::CreateStockObject; CListBox::AddString; CListBox::GetCurSel; CListBox::SetCurSel; CMenu::AppendMenu; CMenu::CreatePopupMenu; CMenu::DeleteMenu; CMenu::Detach; CMenu::DrawItem; CMenu::FromHandle; CMenu::GetMenuItemCount; CMenu::GetSubMenu; CMenu::LoadMenu; CMenu::MeasureItem; CMenu::RemoveMenu; CMenu::TrackPopupMenu; CObject::AssertValid; CObject::Dump; CObject::Serialize; COleDataObject::Attach; COleDataObject::IsDataAvailable; COleDataSource::CacheData; COleDropTarget::Register; COleIPFrameWnd::OnCreateControlBars; COleIPFrameWnd::RepositionFrame; COleMessageFilter::EnableBusyDialog; COleResizeBar::Create; COleServerItem::GetClipboardData; COleServerItem::GetDocument; COleServerItem::OnDraw; COleServerItem::OnDrawEx; COleServerItem::OnGetExtent; COleStreamFile::OpenStream; COleTemplateServer::ConnectTemplate; CPalette::GetPaletteEntries; CPoint::Offset; CRect::BottomRight; CRect::CopyRect; CRect::Height; CRect::IntersectRect; CRect::OffsetRect; CRect::PtInRect; CRect::SetRect; CRect::SetRectEmpty; CRect::Size; CRect::TopLeft; CRect::Width; CStatusBar::Create; CStatusBar::SetIndicators; CString::Collate; CString::Empty; CString::FindOneOf; CString::GetBuffer; CString::GetBufferSetLength; CString::GetLength; CString::IsEmpty; CString::LoadString; CString::MakeUpper; CString::ReleaseBuffer; CString::Right; CToolBar::CommandToIndex; CToolBar::Create; CToolBar::GetItemRect; CToolBar::LoadBitmap; CToolBar::SetButtonInfo; CToolBar::SetButtons; CToolBar::SetSizes; CWinApp::ExitInstance; CWinApp::GetProfileInt; CWinApp::InitInstance; CWinApp::LoadIcon; CWinApp::LoadStdProfileSettings; CWinApp::OnDDECommand; CWinApp::OnFileNew; CWinApp::OnFileOpen; CWinApp::OpenDocumentFile; CWinApp::PreTranslateMessage; CWinApp::SetRegistryKey; CWinApp::WinHelp; CWinApp::WriteProfileInt; CWnd::BringWindowToTop; CWnd::CalcWindowRect; CWnd::CenterWindow; CWnd::ClientToScreen; CWnd::Create; CWnd::DestroyWindow; CWnd::DoDataExchange; CWnd::EnableWindow; CWnd::FromHandle; CWnd::GetCapture; CWnd::GetClientRect; CWnd::GetDlgCtrlID; CWnd::GetDlgItem; CWnd::GetFocus; CWnd::GetNextDlgTabItem; CWnd::GetOwner; CWnd::GetParent; CWnd::GetParentFrame; CWnd::GetSafeHwnd; CWnd::GetScrollPos; CWnd::GetStyle; CWnd::GetWindowPlacement; CWnd::GetWindowRect; CWnd::GetWindowTextLength; CWnd::Invalidate; CWnd::InvalidateRect; CWnd::IsChild; CWnd::IsWindowEnabled; CWnd::MoveWindow; CWnd::OnCommand; CWnd::OnCreate; CWnd::OnDestroy; CWnd::OnDevModeChange; CWnd::OnDropFiles; CWnd::OnEnable; CWnd::OnEraseBkgnd; CWnd::OnFontChange; CWnd::OnLButtonDown; CWnd::OnLButtonUp; CWnd::OnMouseMove; CWnd::OnMove; CWnd::OnPaletteChanged; CWnd::OnQueryNewPalette; CWnd::OnShowWindow; CWnd::OnSize; CWnd::OnSysColorChange; CWnd::OnWindowPosChanged; CWnd::OnWindowPosChanging; CWnd::PreCreateWindow; CWnd::PreTranslateMessage; CWnd::ScreenToClient; CWnd::SendMessage; CWnd::SetCapture; CWnd::SetDlgItemText; CWnd::SetFocus; CWnd::SetOwner; CWnd::SetWindowPos; CWnd::SetWindowText; CWnd::ShowWindow; CWnd::SubclassDlgItem; CWnd::UpdateWindow; CloseHandle; CommDlgExtendedError; CreateEvent; CreateFontIndirect; CreateILockBytesOnHGlobal; CreatePen; CreateSolidBrush; DeleteAtom; DeleteObject; DragAcceptFiles; DragFinish; DragQueryFile; EnumDateFormats; EnumFontFamilies; EnumTimeFormats; EnumWindows; FORMATETC; FindResource; FindWindow; FormatMessage; FreeLibrary; GetClassInfo; GetClassName; GetClientRect; GetClipboardData; GetDC; GetDateFormat; GetDeviceCaps; GetDlgItem; GetKeyState; GetLocalTime; GetLocaleInfo; GetModuleFileName; GetModuleHandle; GetObject; GetProcAddress; GetProfileInt; GetShortPathName; GetStockObject; GetSysColor; GetSystemMetrics; GetTextMetrics; GetTimeFormat; GetUserDefaultLCID; GetVersion; GetWindow; GetWindowText; GlobalAddAtom; GlobalAlloc; GlobalFree; GlobalGetAtomName; GlobalLock; GlobalSize; GlobalUnlock; HIWORD; InvalidateRect; KillTimer; LOWORD; LineTo; LoadBitmap; LoadCursor; LoadIcon; LoadLibrary; LoadString; MAKEINTRESOURCE; MAKELPARAM; MessageBeep; MoveTo; MsgWaitForMultipleObjects; MulDiv; OleInitialize; OleUninitialize; OpenFile; PeekMessage; PtInRect; RGB; ReadClassStg; RegCloseKey; RegCreateKey; RegOpenKey; RegQueryValueEx; RegSetValueEx; RegisterClipboardFormat; ReleaseCapture; ReleaseDC; ReleaseStgMedium; ResetEvent; RestoreDC; RoundRect; STGMEDIUM; SaveDC; SelectObject; SendMessage; SendMessageTimeout; SetEvent; SetFocus; SetForegroundWindow; SetROP2; SetRect; SetTimer; SetWindowPos; SetWindowText; ShellAbout; ShowWindow; StgCreateDocfileOnILockBytes; StgOpenStorage; WinHelp; div; isspace; lstrcat; lstrcmp; lstrcmpi; lstrcpy; lstrlen; max; memcmp; memcpy; memmove; memset; min; strcpy; wsprintf 

### Note
Some samples, such as this one, have not been modified to reflect the changes in the Visual C++ wizards, libraries, and compiler, but still demonstrate how to complete your desired task.

© Microsoft Corporation. All rights reserved.